from datetime import datetime
import pytz  # Make sure to install pytz using `pip install pytz`
import time
from ringcentral import SDK
import json
from collections import defaultdict

# Setup
config = {
    "client_id": "1CayFASqF2Qdv1MFI2nDgo",
    "client_secret": "Xim1wYJpsORcp3d4KrwrjHZr9t2ckc8H9cvPkhtmHxpV",
    "server_url": "https://platform.ringcentral.com",
    "jwt": {
        "Reports": "eyJraWQiOiI4NzYyZjU5OGQwNTk0NGRiODZiZjVjYTk3ODA0NzYwOCIsInR5cCI6IkpXVCIsImFsZyI6IlJTMjU2In0.eyJhdWQiOiJodHRwczovL3BsYXRmb3JtLnJpbmdjZW50cmFsLmNvbS9yZXN0YXBpL29hdXRoL3Rva2VuIiwic3ViIjoiMjIzNzIxMDQyIiwiaXNzIjoiaHR0cHM6Ly9wbGF0Zm9ybS5yaW5nY2VudHJhbC5jb20iLCJleHAiOjIyNDAyNjU1OTksImlhdCI6MTcwMTEwMzI5MywianRpIjoiYkxGZDJqOTVSUWk2THROcW1JLVhFZyJ9.ALtTujcoO5CNQmkh-YX-tMibPE2Szx3Kzt8PsEKPetygnW23HCpKtaXufDjgG_qMe5PxfcuGQgLITU3gGh_H4k4kSIlviyJTrWwiwwOcBTsorNbIQMjbVwNdpMZGfzCf1bqkAFq7FIJMfR0KopXSBSL5RsnkWa12Vm_uUEQBIpiZd0T0F9uVJeaVcQlOPr4dK1zae3XEtqubdWT6xyAqli-glTj4IDgn-VNfM2WGk63QMb6ApraALmwulNCjqNPK6bJ7Q2U65zMPRDJmfy-jVpdS7KABBuj76bt0itBwt_-EdYp92DjB8-aHEsJiaLOYMW2bKuAqq95hHlJbnQ45fQ"
    }
}

# List of users to hide
hidden_users = ["Emma Crane", "Nathan Oliver", "Fran Ferreria"]

rcsdk = SDK(config["client_id"], config["client_secret"], config["server_url"])
platform = rcsdk.platform()

# Login
try:
    platform.login(jwt=config["jwt"]["Reports"])
except Exception as e:
    print(json.dumps({"error": f"Login failed: {str(e)}"}))
    exit()

# Date for filtering
today_iso = datetime.utcnow().strftime('%Y-%m-%dT00:00:00.000Z')

# Retry logic with exponential backoff
max_retries = 5
retry_delay = 1  # Initial delay in seconds

for attempt in range(max_retries):
    try:
        # Fetch call logs
        response = platform.get('/restapi/v1.0/account/~/call-log', {
            'dateFrom': today_iso,
            'type': 'Voice'
        })

        # If the request is successful, break out of the loop
        break

    except Exception as e:
        # Check if the error is related to rate limiting
        if 'Request rate exceeded' in str(e):
            print(f"Rate limit exceeded, retrying in {retry_delay} seconds...")
            time.sleep(retry_delay)
            retry_delay *= 2  # Exponential backoff (increase delay with each retry)
        else:
            # Other errors are raised immediately
            print(json.dumps({"error": f"Failed to fetch call logs: {str(e)}"}))
            exit()

# If the loop completed without success, exit
if attempt == max_retries - 1:
    print(json.dumps({"error": "Max retries exceeded. Could not fetch call logs."}))
    exit()

# Process call logs
try:
    call_logs = json.loads(response.text())
    user_durations = defaultdict(int)
    last_call_times = {}
    now = datetime.now(pytz.UTC)  # Ensure current time is aware (UTC)

    results = []
    for record in call_logs.get('records', []):
        from_info = record.get('from', {})
        user_name = from_info.get('name') or from_info.get('extensionNumber') or "Unknown"
        
        # Skip hidden users
        if user_name in hidden_users:
            continue
        
        call_time_str = record.get('startTime')  # Get call start time
        call_time = datetime.strptime(call_time_str, "%Y-%m-%dT%H:%M:%S.%fZ")  # Parse start time as a naive datetime
        call_time = pytz.UTC.localize(call_time)  # Localize to UTC

        duration = record.get('duration', 0)
        user_durations[user_name] += duration
        last_call_times[user_name] = call_time  # Store last call time

    # Create final user results
    for user, total_secs in sorted(user_durations.items(), key=lambda x: -x[1]):
        total_minutes, total_seconds = divmod(total_secs, 60)
        total_hours, total_minutes = divmod(total_minutes, 60)  # Convert to hours and minutes
        total_call_time = f"{total_hours}hr {total_minutes}m"

        last_call_time = last_call_times[user]
        time_diff = now - last_call_time
        time_diff_minutes = time_diff.total_seconds() / 60  # Convert seconds to minutes

        if time_diff_minutes < 60:
            last_call_ago = f"{int(time_diff_minutes)} minutes ago"
        else:
            time_diff_hours = time_diff_minutes / 60
            last_call_ago = f"{int(time_diff_hours)} hours ago"

        results.append({
            'name': user,
            'last_call_ago': last_call_ago,
            'total_call_time': total_call_time
        })

    print(json.dumps({"users": results}))

except Exception as e:
    print(json.dumps({"error": f"Failed to process call logs: {str(e)}"}))